<?php

return [

    'cheatsheet' => '
<p>Markdown is a text-to-HTML markup syntax for web writers. Markdown allows you to write using an easy-to-read, easy-to-write plain text format that is converted to structurally valid HTML.</p>

<h3>Headers</h3>
<pre class="language-markdown"><code># This is an h1
## This is an h2
### This is an h3, and so on.
</code></pre>

<h3>Bold &amp; Italic</h3>
<pre class="language-markdown"><code>You can make things *emphasized*, **bold**, or _**both**_.</code></pre>

<h3>Links</h3>
<pre class="language-markdown"><code>This is an [example link](http://example.com).</code></pre>

<h3>Code</h3>
<p>
Wrap your code with 3 backticks (<code>```</code>) on the line before and after.
</p>

<pre class="language-markdown"><code>```
this: is some yaml
```</code></pre>

<p>You can also add code inline by wrapping content with <code>`</code> single backticks.

<h3>Quoting</h3>

<p>Create a blockquote by starting your text with <code>> </code>.</p>

<pre class="language-markdown"><code>> This is going to be a blockquote.</code></pre>

<h3>Images</h3>
<pre class="language-markdown"><code>![alt text](http://example.com/image.jpg)</code></pre>

<h3>Unordered List</h3>
<pre class="language-markdown"><code>- Bacon
- Steak
- Beer</code></pre>

<h3>Ordered List</h3>
<pre class="language-markdown"><code>1. Eat
2. Drink
3. Be merry</code></pre>

<h3>Tables</h3>

<pre class="language-markdown"><code>First Header  | Second Header
------------- | -------------
Content Cell  | Content Cell
Content Cell  | Content Cell</code></pre>',

];
